/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.client;

import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_3929;
import org.ladysnake.blabber.Blabber;
import org.ladysnake.blabber.api.client.BlabberDialogueScreen;
import org.ladysnake.blabber.api.client.BlabberScreenRegistry;
import org.ladysnake.blabber.api.client.illustration.DialogueIllustrationRenderer;
import org.ladysnake.blabber.api.illustration.DialogueIllustration;
import org.ladysnake.blabber.api.illustration.DialogueIllustrationType;
import org.ladysnake.blabber.api.layout.DialogueLayout;
import org.ladysnake.blabber.api.layout.DialogueLayoutType;
import org.ladysnake.blabber.impl.client.BlabberRpgDialogueScreen;
import org.ladysnake.blabber.impl.client.illustrations.FakePlayerIllustrationRenderer;
import org.ladysnake.blabber.impl.client.illustrations.IllustrationCollectionRenderer;
import org.ladysnake.blabber.impl.client.illustrations.ItemIllustrationRenderer;
import org.ladysnake.blabber.impl.client.illustrations.NbtEntityIllustrationRenderer;
import org.ladysnake.blabber.impl.client.illustrations.SelectedEntityIllustrationRenderer;
import org.ladysnake.blabber.impl.client.illustrations.TextureIllustrationRenderer;
import org.ladysnake.blabber.impl.common.BlabberRegistrar;
import org.ladysnake.blabber.impl.common.DialogueRegistry;
import org.ladysnake.blabber.impl.common.DialogueScreenHandler;
import org.ladysnake.blabber.impl.common.illustrations.DialogueIllustrationCollection;
import org.ladysnake.blabber.impl.common.illustrations.DialogueIllustrationItem;
import org.ladysnake.blabber.impl.common.illustrations.DialogueIllustrationTexture;
import org.ladysnake.blabber.impl.common.illustrations.entity.DialogueIllustrationFakePlayer;
import org.ladysnake.blabber.impl.common.illustrations.entity.DialogueIllustrationNbtEntity;
import org.ladysnake.blabber.impl.common.illustrations.entity.DialogueIllustrationSelectorEntity;
import org.ladysnake.blabber.impl.common.packets.ChoiceAvailabilityPayload;
import org.ladysnake.blabber.impl.common.packets.DialogueListPayload;
import org.ladysnake.blabber.impl.common.packets.SelectedDialogueStatePayload;

public final class BlabberClient
implements ClientModInitializer {
    private static final Map<DialogueLayoutType<?>, class_3929.class_3930<?, ?>> screenRegistry = new LinkedHashMap();
    private static final Map<DialogueIllustrationType<?>, DialogueIllustrationRenderer.Factory<?>> illustrationRenderers = new LinkedHashMap();

    public void onInitializeClient() {
        DialogueIllustrationRenderer.register(DialogueIllustrationCollection.TYPE, IllustrationCollectionRenderer::new);
        DialogueIllustrationRenderer.register(DialogueIllustrationItem.TYPE, ItemIllustrationRenderer::new);
        DialogueIllustrationRenderer.register(DialogueIllustrationNbtEntity.TYPE, NbtEntityIllustrationRenderer::new);
        DialogueIllustrationRenderer.register(DialogueIllustrationFakePlayer.TYPE, FakePlayerIllustrationRenderer::new);
        DialogueIllustrationRenderer.register(DialogueIllustrationSelectorEntity.TYPE, SelectedEntityIllustrationRenderer::new);
        DialogueIllustrationRenderer.register(DialogueIllustrationTexture.TYPE, TextureIllustrationRenderer::new);
        BlabberScreenRegistry.register(BlabberRegistrar.CLASSIC_LAYOUT, BlabberDialogueScreen::new);
        BlabberScreenRegistry.register(BlabberRegistrar.RPG_LAYOUT, BlabberRpgDialogueScreen::new);
        class_3929.method_17542(BlabberRegistrar.DIALOGUE_SCREEN_HANDLER, BlabberClient::createDialogueScreen);
        ClientConfigurationNetworking.registerGlobalReceiver(DialogueListPayload.ID, (packet, ctx) -> DialogueRegistry.setClientIds(packet.dialogueIds()));
        ClientPlayNetworking.registerGlobalReceiver(DialogueListPayload.ID, (packet, ctx) -> DialogueRegistry.setClientIds(packet.dialogueIds()));
        ClientPlayNetworking.registerGlobalReceiver(ChoiceAvailabilityPayload.ID, (packet, ctx) -> {
            class_1703 patt0$temp = ctx.player().field_7512;
            if (patt0$temp instanceof DialogueScreenHandler) {
                DialogueScreenHandler dialogueScreenHandler = (DialogueScreenHandler)patt0$temp;
                dialogueScreenHandler.handleAvailabilityUpdate((ChoiceAvailabilityPayload)packet);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(SelectedDialogueStatePayload.ID, (packet, ctx) -> {
            class_1703 patt0$temp = ctx.player().field_7512;
            if (patt0$temp instanceof DialogueScreenHandler) {
                DialogueScreenHandler dialogueScreenHandler = (DialogueScreenHandler)patt0$temp;
                dialogueScreenHandler.setCurrentState(packet.stateKey());
            }
        });
    }

    public static <P extends DialogueLayout.Params> void registerLayoutScreen(DialogueLayoutType<P> layoutId, class_3929.class_3930<DialogueScreenHandler, BlabberDialogueScreen<P>> screenProvider) {
        screenRegistry.put(layoutId, screenProvider);
    }

    public static <I extends DialogueIllustration> void registerIllustrationRenderer(DialogueIllustrationType<I> type, DialogueIllustrationRenderer.Factory<I> rendererFactory) {
        illustrationRenderers.put(type, rendererFactory);
    }

    public static <I extends DialogueIllustration> DialogueIllustrationRenderer<I> createRenderer(I illustration) {
        DialogueIllustrationRenderer.Factory<?> renderer = illustrationRenderers.get(illustration.getType());
        return renderer.create(illustration);
    }

    private static <P extends DialogueLayout.Params> BlabberDialogueScreen<P> createDialogueScreen(DialogueScreenHandler handler, class_1661 inventory, class_2561 title) {
        DialogueLayoutType<DialogueLayout.Params> layoutType = handler.getLayout().type();
        class_3929.class_3930<?, ?> provider = screenRegistry.get(layoutType);
        if (provider != null) {
            return (BlabberDialogueScreen)provider.create((class_1703)handler, inventory, title);
        }
        Blabber.LOGGER.error("(Blabber) No screen provider found for {}", layoutType);
        return new BlabberDialogueScreen(handler, inventory, title);
    }
}

